/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.exportacion;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores.ModeloValoresPagoLocal;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.ClienteExportacion;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.ComprobanteExportacion;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.Refrendo;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Exportacion
extends ObjetoModeloSucesorValidableAnotado<Iva>
implements InformacionEditable<Exportacion>,
Exportable,
Importable {
    private static final int JUNIO = 6;
    private static final int DICIEMBRE = 12;
    private static final long serialVersionUID = -4093185683327800966L;
    public static final String C_TIPO_EXPORTACION_DE = "tipoExportacionDe";
    public static final String C_FECHA_TRANSACCION = "fechaTransaccion";
    public static final String C_NUMERO_FUE = "numeroFue";
    public static final String C_VALOR_FOB = "valorFob";
    public static final String CON_REFRENDO = "01";
    public static final String EXPORTACION_DE_SERVICIOS = "03";
    private static final String NUMFUE = "No. FUE";
    private static final String VALORFOB = "FOB/Valor del ingreso del exterior";
    private static final String VALOR = "El valor ";
    private static final String MSG_REG_FUE = "El valor No. FUE debe ser solo n\u00fameros. Diferente de cero. ";
    private static final String MSG_REG_FOB = "El valor FOB/Valor del ingreso del exterior debe ser 12 enteros y 2 decimales. Diferente de cero. ";
    private Refrendo refrendo = new Refrendo();
    private ComprobanteExportacion comprobanteExportacion;
    private ClienteExportacion clienteExportacion;
    @NotNull(message="Debe seleccionar el tipo de exportaci\u00f3n")
    private String tipoExportacionDe;
    private String descripcionTipoExportacionDe;
    @NotNull(message="Debe ingresar el valor de Fecha de Transacci\u00f3n")
    private Date fechaTransaccion;
    private String numeroFue;
    @NotNull(message="Debe ingresar el valor de FOB/Valor del ingreso del exterior")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor FOB/Valor del ingreso del exterior debe ser 12 enteros y 2 decimales. Diferente de cero. ")
    private String valorFob;
    private String tipoIngresoDelExterior;
    private String descripcionTipoIngresoDelExterior;
    private boolean esIngresoDelExteriorGravado;
    private String valorImpuestoOtroPais;
    private boolean regimenEcuapass;

    public Exportacion() {
        this.refrendo.setPropietario((ObjetoModelo)this);
        this.comprobanteExportacion = new ComprobanteExportacion();
        this.comprobanteExportacion.setPropietario((ObjetoModelo)this);
        this.clienteExportacion = new ClienteExportacion();
        this.clienteExportacion.setPropietario((ObjetoModelo)this);
        this.esIngresoDelExteriorGravado = false;
        this.valorFob = "0.00";
        this.numeroFue = "0";
        this.regimenEcuapass = true;
    }

    public void inicializar() {
        this.inicializarRegimenEcuapass();
        this.fechaTransaccion = ((Iva)this.getRaizModelo()).periodo.getFechaDeclarada().toDate();
        this.refrendo.inicializar();
        this.comprobanteExportacion.inicializar();
    }

    private void inicializarRegimenEcuapass() {
        if (((Iva)this.getRaizModelo()).getFechaPeriodoDeclarado().before(Constantes.FECHA_VIGENCIA_ECUAPASS)) {
            this.regimenEcuapass = false;
        }
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (InfoPantallas.EXPORTACIONES_REFRENDO.equals(this.getContextoValidacion().obtener(InfoPantallas.EXPORTACIONES_REFRENDO.toString()))) {
            boolean esExportacionDeServiciosDesdeMayo2016;
            boolean bl = esExportacionDeServiciosDesdeMayo2016 = EXPORTACION_DE_SERVICIOS.equals(this.getTipoExportacionDe()) && ((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016();
            if (esExportacionDeServiciosDesdeMayo2016) {
                if (!this.validarTipoDeIngresoDelExterior(resultado).esEstadoExitoso()) {
                    return resultado;
                }
                this.validarImpuestoPagadoEnElExterior(resultado).esEstadoExitoso();
            }
            this.validarValorFOB(resultado);
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            this.validarFechaTransaccion(resultado);
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            if (!this.isRegimenEcuapass()) {
                this.validarNumeroFue(resultado);
                if (!resultado.esEstadoExitoso()) {
                    return resultado;
                }
            }
            if (CON_REFRENDO.equals(this.getTipoExportacionDe()) && !(resultado = this.getRefrendo().validar()).esEstadoExitoso()) {
                return resultado;
            }
            this.formatearValores();
        }
        if (InfoPantallas.EXPORTACIONES_COMPROBANTE.equals(this.getContextoValidacion().obtener(InfoPantallas.EXPORTACIONES_COMPROBANTE.toString())) && !(resultado = this.getComprobanteExportacion().validar()).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    private ResultadoValidacion validarTipoDeIngresoDelExterior(ResultadoValidacion resultado) {
        if (this.tipoIngresoDelExterior == null) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de Ingreso del Exterior");
        }
        return resultado;
    }

    private ResultadoValidacion validarImpuestoPagadoEnElExterior(ResultadoValidacion resultado) {
        java.util.regex.Pattern patronValor;
        Matcher matcher;
        if (this.esIngresoDelExteriorGravado && this.valorImpuestoOtroPais == null) {
            return resultado.fallarValidacion("Debe ingresar el monto de impuesto pagado en el exterior");
        }
        if (this.valorImpuestoOtroPais != null && !(matcher = (patronValor = java.util.regex.Pattern.compile("^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$")).matcher(this.valorImpuestoOtroPais)).matches()) {
            return resultado.fallarValidacion("El valor de impuesto pagado en el exterior deben ser num\u00e9rico y con 2 decimales ");
        }
        return resultado;
    }

    public Exportacion crearCopiaEdicion() {
        Exportacion copia = new Exportacion();
        copia.setTipoExportacionDe(this.tipoExportacionDe);
        copia.setDescripcionTipoExportacionDe(this.descripcionTipoExportacionDe);
        copia.setFechaTransaccion(this.fechaTransaccion);
        copia.setNumeroFue(this.numeroFue);
        copia.setTipoIngresoDelExterior(this.tipoIngresoDelExterior);
        copia.setDescripcionTipoIngresoDelExterior(this.descripcionTipoIngresoDelExterior);
        copia.setEsIngresoDelExteriorGravado(this.esIngresoDelExteriorGravado);
        copia.setValorImpuestoOtroPais(this.valorImpuestoOtroPais);
        copia.setValorFob(this.valorFob);
        copia.setRegimenEcuapass(this.regimenEcuapass);
        copia.setPropietario((Iva)this.propietario);
        copia.setRefrendo(this.refrendo.crearCopiaEdicion());
        copia.getRefrendo().setPropietario((ObjetoModelo)copia);
        copia.setComprobanteExportacion(this.comprobanteExportacion.crearCopiaEdicion());
        copia.getComprobanteExportacion().setPropietario((ObjetoModelo)copia);
        copia.setClienteExportacion(this.clienteExportacion.crearCopiaEdicion());
        copia.getClienteExportacion().setPropietario((ObjetoModelo)copia);
        return copia;
    }

    public void actualizarInformacion(Exportacion copiaEdicion) {
        this.setTipoExportacionDe(copiaEdicion.getTipoExportacionDe());
        this.setDescripcionTipoExportacionDe(copiaEdicion.getDescripcionTipoExportacionDe());
        this.setFechaTransaccion(copiaEdicion.getFechaTransaccion());
        this.setNumeroFue(copiaEdicion.getNumeroFue());
        this.setValorFob(copiaEdicion.getValorFob());
        this.setTipoIngresoDelExterior(copiaEdicion.getTipoIngresoDelExterior());
        this.setDescripcionTipoIngresoDelExterior(copiaEdicion.getDescripcionTipoIngresoDelExterior());
        this.setEsIngresoDelExteriorGravado(copiaEdicion.isEsIngresoDelExteriorGravado());
        this.setValorImpuestoOtroPais(copiaEdicion.getValorImpuestoOtroPais());
    }

    private ResultadoValidacion validarFechaTransaccion(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        boolean esMicroEmpresa = iva.getDatosDeclaracion().isEsMicroEmpresa();
        if (esMicroEmpresa) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.getFechaTransaccion());
            int anioTransaccion = calendar.get(1);
            int mesTransaccion = calendar.get(2) + 1;
            int anioDeclarado = iva.getFechaPeriodoDeclarado().get(1);
            int mesDeclarado = iva.getFechaPeriodoDeclarado().get(2) + 1;
            if (anioDeclarado != anioTransaccion || mesDeclarado == 6 && mesTransaccion > 6 || mesDeclarado == 12 && mesTransaccion < 6) {
                Date date = iva.getFechaPeriodoDeclarado().getTime();
                SimpleDateFormat format1 = new SimpleDateFormat("dd-MM-yyyy");
                String date1 = format1.format(date);
                return resultado.fallarValidacion(String.format("La fecha de %s debe pertenecer al per\u00edodo informado %s para microempresas", "transacci\u00f3n", date1));
            }
        } else if (!Util.isFechasIgualesMesAnio(this.getFechaTransaccion(), iva.getFechaPeriodoDeclarado())) {
            return resultado.fallarValidacion(String.format("La fecha de %s debe ser %s a la fecha del per\u00edodo informado", "transacci\u00f3n", "igual"));
        }
        return resultado;
    }

    private ResultadoValidacion validarNumeroFue(ResultadoValidacion resultado) {
        if (!java.util.regex.Pattern.matches("^0*([1-9]\\d{0,})$", this.getNumeroFue())) {
            return resultado.fallarValidacion(MSG_REG_FUE);
        }
        if (this.getNumeroFue().trim().length() > 13) {
            return resultado.fallarValidacion("Debe ingresar hasta trece d\u00edgitos");
        }
        return resultado;
    }

    private ResultadoValidacion validarValorFOB(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getValorFob()).compareTo(BigDecimal.ZERO) == 0) {
            return resultado.fallarValidacion(MSG_REG_FOB);
        }
        return resultado;
    }

    private void formatearValores() {
        this.setNumeroFue(Util.getCadenaFormateada(this.getNumeroFue(), "13", Character.valueOf('0')));
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = null;
        Element eValor = null;
        if (((Iva)this.getRaizModelo()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            this.getClienteExportacion().importar(elemento, null);
            if (Util.existeElementoImportar(elemento, "paisEfecExp")) {
                ModeloValoresPagoLocal modeloValores = new ModeloValoresPagoLocal(((Iva)this.getPropietario()).periodo.getFechaDeclarada());
                modeloValores.inicializaPeriodo(((Iva)this.getPropietario()).periodo);
                modeloValores.inicializar();
                valorList = elemento.getElementsByTagName("paisEfecExp");
                eValor = (Element)valorList.item(0);
                this.getClienteExportacion().getPagoLocalExterior().getFiscalidad().setPaisPago(eValor.getTextContent().trim());
                this.getClienteExportacion().getPagoLocalExterior().getFiscalidad().setDescripcionPaisPago(modeloValores.obtenerPais(eValor.getTextContent().trim()).getEtiqueta());
            }
            if (Util.existeElementoImportar(elemento, "pagoRegFis")) {
                valorList = elemento.getElementsByTagName("pagoRegFis");
                eValor = (Element)valorList.item(0);
                this.getClienteExportacion().getPagoLocalExterior().setPagoRegimenFiscal(Util.importarBooleano(eValor));
            }
        }
        valorList = elemento.getElementsByTagName("exportacionDe");
        eValor = (Element)valorList.item(0);
        this.tipoExportacionDe = eValor.getTextContent().trim();
        this.descripcionTipoExportacionDe = UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOSEXP", (String)this.getTipoExportacionDe()).toUpperCase();
        this.importarDatosDeExportacionDeServicios(elemento);
        this.inicializarRegimenEcuapass();
        this.getRefrendo().setPropietario((ObjetoModelo)this);
        this.getRefrendo().inicializar();
        if (CON_REFRENDO.equals(this.getTipoExportacionDe())) {
            this.getRefrendo().importar(elemento, null);
        }
        valorList = elemento.getElementsByTagName("fechaEmbarque");
        eValor = (Element)valorList.item(0);
        this.fechaTransaccion = Util.importarFecha(eValor);
        if (this.getRefrendo().getFlagVerificador()) {
            valorList = elemento.getElementsByTagName("fue");
            eValor = (Element)valorList.item(0);
            this.numeroFue = eValor.getTextContent();
        }
        valorList = elemento.getElementsByTagName("valorFOB");
        eValor = (Element)valorList.item(0);
        this.valorFob = eValor.getTextContent().trim();
        this.getComprobanteExportacion().importar(elemento, null);
        return this;
    }

    private void importarDatosDeExportacionDeServicios(Element elemento) {
        if (EXPORTACION_DE_SERVICIOS.equals(this.tipoExportacionDe)) {
            Element eValor;
            NodeList valorList;
            if (Util.existeElementoImportar(elemento, "tipIngExt")) {
                valorList = elemento.getElementsByTagName("tipIngExt");
                eValor = (Element)valorList.item(0);
                this.tipoIngresoDelExterior = eValor.getTextContent().trim();
            }
            this.descripcionTipoIngresoDelExterior = UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOREGIMENEXT", (String)this.getTipoIngresoDelExterior());
            if (Util.existeElementoImportar(elemento, "tipIngExt")) {
                valorList = elemento.getElementsByTagName("tipIngExt");
                eValor = (Element)valorList.item(0);
                this.esIngresoDelExteriorGravado = Util.importarBooleano(eValor);
            }
            if (this.esIngresoDelExteriorGravado && Util.existeElementoImportar(elemento, "impuestoOtroPais")) {
                valorList = elemento.getElementsByTagName("impuestoOtroPais");
                eValor = (Element)valorList.item(0);
                this.valorImpuestoOtroPais = eValor.getTextContent().trim();
            }
        }
    }

    public Refrendo getRefrendo() {
        return this.refrendo;
    }

    public ComprobanteExportacion getComprobanteExportacion() {
        return this.comprobanteExportacion;
    }

    public String getTipoExportacionDe() {
        return this.tipoExportacionDe;
    }

    public String getDescripcionTipoExportacionDe() {
        return this.descripcionTipoExportacionDe;
    }

    public Date getFechaTransaccion() {
        return this.fechaTransaccion;
    }

    public String getNumeroFue() {
        return this.numeroFue;
    }

    public String getValorFob() {
        return this.valorFob;
    }

    public boolean isRegimenEcuapass() {
        return this.regimenEcuapass;
    }

    public void setRefrendo(Refrendo refrendo) {
        this.refrendo = refrendo;
    }

    public void setComprobanteExportacion(ComprobanteExportacion comprobanteExportacion) {
        this.comprobanteExportacion = comprobanteExportacion;
    }

    public void setTipoExportacionDe(String tipoExportacionDe) {
        String oldValue = this.tipoExportacionDe;
        this.tipoExportacionDe = StringUtil.isNullOrEmpty((String)tipoExportacionDe) ? tipoExportacionDe : tipoExportacionDe.toUpperCase();
        this.firePropertyChange(C_TIPO_EXPORTACION_DE, oldValue, this.tipoExportacionDe);
    }

    public void setDescripcionTipoExportacionDe(String descripcionTipoExportacionDe) {
        this.descripcionTipoExportacionDe = descripcionTipoExportacionDe;
    }

    public void setFechaTransaccion(Date fechaTransaccion) {
        Date oldValue = this.fechaTransaccion;
        this.fechaTransaccion = fechaTransaccion;
        this.firePropertyChange(C_FECHA_TRANSACCION, oldValue, this.fechaTransaccion);
    }

    public void setNumeroFue(String numeroFue) {
        String oldValue = this.numeroFue;
        this.numeroFue = numeroFue;
        this.firePropertyChange(C_NUMERO_FUE, oldValue, this.numeroFue);
    }

    public void setValorFob(String valorFob) {
        String oldValue = this.valorFob;
        this.valorFob = valorFob;
        this.firePropertyChange(C_VALOR_FOB, oldValue, this.valorFob);
    }

    public void setRegimenEcuapass(boolean regimenEcuapass) {
        this.regimenEcuapass = regimenEcuapass;
    }

    public ClienteExportacion getClienteExportacion() {
        return this.clienteExportacion;
    }

    public String getTipoIngresoDelExterior() {
        return this.tipoIngresoDelExterior;
    }

    public void setTipoIngresoDelExterior(String tipoIngresoDelExterior) {
        String oldValue = this.tipoIngresoDelExterior;
        this.tipoIngresoDelExterior = tipoIngresoDelExterior;
        this.firePropertyChange("tipoIngresoDelExterior", oldValue, this.tipoIngresoDelExterior);
    }

    public boolean isEsIngresoDelExteriorGravado() {
        return this.esIngresoDelExteriorGravado;
    }

    public String getIngresoDelExteriorGravado() {
        return this.esIngresoDelExteriorGravado ? "SI" : "NO";
    }

    public void setEsIngresoDelExteriorGravado(boolean esIngresoDelExteriorGravado) {
        boolean oldValue = this.esIngresoDelExteriorGravado;
        this.esIngresoDelExteriorGravado = esIngresoDelExteriorGravado;
        this.firePropertyChange("esIngresoDelExteriorGravado", oldValue, this.esIngresoDelExteriorGravado);
    }

    public String getValorImpuestoOtroPais() {
        return this.valorImpuestoOtroPais;
    }

    public String getDescripcionTipoIngresoDelExterior() {
        return this.descripcionTipoIngresoDelExterior;
    }

    public void setValorImpuestoOtroPais(String valorImpuestoOtroPais) {
        String oldValue = this.valorImpuestoOtroPais;
        this.valorImpuestoOtroPais = valorImpuestoOtroPais;
        this.firePropertyChange("valorImpuestoOtroPais", oldValue, this.valorImpuestoOtroPais);
    }

    public void setDescripcionTipoIngresoDelExterior(String descripcionTipoIngresoDelExterior) {
        this.descripcionTipoIngresoDelExterior = descripcionTipoIngresoDelExterior;
    }

    public void setClienteExportacion(ClienteExportacion clienteExportacion) {
        this.clienteExportacion = clienteExportacion;
    }

    public Element exportar(Document documento, Element elemento) {
        boolean esExportacionDeServiciosDesdeMayo2016;
        Element elmExport = documento.createElement("detalleExportaciones");
        Element emDetExp = null;
        if (((Iva)this.getPropietario()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            this.getClienteExportacion().exportar(documento, elmExport);
        }
        emDetExp = documento.createElement("exportacionDe");
        emDetExp.setTextContent(this.getTipoExportacionDe());
        elmExport.appendChild(emDetExp);
        boolean bl = esExportacionDeServiciosDesdeMayo2016 = EXPORTACION_DE_SERVICIOS.equals(this.getTipoExportacionDe()) && ((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016();
        if (esExportacionDeServiciosDesdeMayo2016) {
            emDetExp = documento.createElement("tipIngExt");
            emDetExp.setTextContent(this.getTipoIngresoDelExterior());
            elmExport.appendChild(emDetExp);
            emDetExp = documento.createElement("ingExtGravOtroPais");
            emDetExp.setTextContent(this.getIngresoDelExteriorGravado());
            elmExport.appendChild(emDetExp);
            if (this.isEsIngresoDelExteriorGravado()) {
                emDetExp = documento.createElement("impuestoOtroPais");
                emDetExp.setTextContent(this.getValorImpuestoOtroPais());
                elmExport.appendChild(emDetExp);
            }
        }
        emDetExp = documento.createElement("tipoComprobante");
        emDetExp.setTextContent(this.getComprobanteExportacion().getTipoComprobante());
        elmExport.appendChild(emDetExp);
        if (CON_REFRENDO.equals(this.getTipoExportacionDe())) {
            emDetExp = documento.createElement("distAduanero");
            emDetExp.setTextContent(this.getRefrendo().getTipoDistritoAduanero());
            elmExport.appendChild(emDetExp);
            emDetExp = documento.createElement("anio");
            emDetExp.setTextContent(this.getRefrendo().getAnio());
            elmExport.appendChild(emDetExp);
            emDetExp = documento.createElement("regimen");
            emDetExp.setTextContent(this.getRefrendo().getTipoRegimen());
            elmExport.appendChild(emDetExp);
            emDetExp = documento.createElement("correlativo");
            emDetExp.setTextContent(this.getRefrendo().getCorrelativo());
            elmExport.appendChild(emDetExp);
            if (this.getRefrendo().getFlagVerificador()) {
                emDetExp = documento.createElement("verificador");
                emDetExp.setTextContent(this.getRefrendo().getVerificador());
                elmExport.appendChild(emDetExp);
            }
            emDetExp = documento.createElement("docTransp");
            emDetExp.setTextContent(this.getRefrendo().getNumeroDocTransporte());
            elmExport.appendChild(emDetExp);
        }
        emDetExp = documento.createElement("fechaEmbarque");
        emDetExp.setTextContent(Util.dateToStringWithFormat(this.getFechaTransaccion(), Constantes.FORMATO_FECHA.toPattern()));
        elmExport.appendChild(emDetExp);
        if (this.getRefrendo().getFlagVerificador()) {
            emDetExp = documento.createElement("fue");
            emDetExp.setTextContent(this.getNumeroFue());
            elmExport.appendChild(emDetExp);
        }
        emDetExp = documento.createElement("valorFOB");
        emDetExp.setTextContent(this.getValorFob());
        elmExport.appendChild(emDetExp);
        emDetExp = documento.createElement("valorFOBComprobante");
        emDetExp.setTextContent(this.getComprobanteExportacion().getValorComprobanteLocal());
        elmExport.appendChild(emDetExp);
        emDetExp = documento.createElement("establecimiento");
        emDetExp.setTextContent(this.getComprobanteExportacion().getEstablecimiento());
        elmExport.appendChild(emDetExp);
        emDetExp = documento.createElement("puntoEmision");
        emDetExp.setTextContent(this.getComprobanteExportacion().getPuntoEmision());
        elmExport.appendChild(emDetExp);
        emDetExp = documento.createElement("secuencial");
        emDetExp.setTextContent(this.getComprobanteExportacion().getSecuencial());
        elmExport.appendChild(emDetExp);
        emDetExp = documento.createElement("autorizacion");
        emDetExp.setTextContent(this.getComprobanteExportacion().getNumAutorizacion());
        elmExport.appendChild(emDetExp);
        emDetExp = documento.createElement("fechaEmision");
        emDetExp.setTextContent(Util.dateToStringWithFormat(this.getComprobanteExportacion().getFechaEmision(), Constantes.FORMATO_FECHA.toPattern()));
        elmExport.appendChild(emDetExp);
        return elmExport;
    }
}

